
/**
 * Write a description of class Album here.
 *
 * @author (your name)
 * @version (a version number or a date)
 */

import java.util.ArrayList;

public class Album {
    
    private String title;
    private Performer performer;
    private int year;
    private Song[] songs;
    private ArrayList<String> credits;
    
    public Album(String title, Performer performer, int year, 
                 Song[] songs, ArrayList<String> credits) {
        this.title = title;
        this.performer = performer;
        this.year = year;
        this.songs = songs;
        this.credits = credits;
    }
    
    public Album(String title, Performer performer, int year, Song[] songs) {
        this.title = title;
        this.performer = performer;
        this.year = year;
        this.songs = songs;
    }
    
    public Album(String title, Performer performer, int year, int noOfSongs) {
        this.title = title;
        this.performer = performer;
        this.year = year;
        this.songs = new Song[noOfSongs];
        for (int i = 0; i < noOfSongs; i++) {
            songs[i] = new Song();
            songs[i].setTitle("Temporary title");
        }
    }
    
    public Album(String title, Performer performer, int year) {
        this.title = title;
        this.performer = performer;
        this.year = year;
    }
    
    public Album() {
    }
    
    public void display() {
        // System.out.println(this.title);
        // System.out.println(this.year);
        System.out.println("Album: " + this.title + " (" + this.year + ")");
        System.out.println("Songs: ");
        for (int i = 0; i < songs.length; i++) {
            System.out.println('\t' + songs[i].getTitle());
        }
        System.out.println("Credits: ");
        for (int i = 0; i < credits.size(); i++) {
            System.out.println('\t' + credits.get(i));
        }
    }
    
    public void setTitle(String title) {
        if ((title != null) && (title != "")) {
            this.title = title;
        } else {
            System.out.println("Error: title must have at least 1 char");
        }
    }
    
    public String getTitle() {
        return this.title;
    }
    
    public void setPerformer(Performer performer) {
        this.performer = performer;
    }
    
    public Performer getPerformer() {
        return this.performer;
    }
    
    public void setYear(int year) {
        this.year = year;
    }
    
    public int getYear() {
        return this.year;
    }
    
    public void setSongs(Song[] songs) {
        this.songs = songs;
    }
    
    public Song[] getSongs() {
        return this.songs;
    }
    
    public void setCredits(ArrayList<String> credits) {
        this.credits = credits;
    }
    
    public ArrayList<String> getCredits() {
        return this.credits;
    }
}
